<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["error" => "Neizdevās izveidot savienojumu ar datubāzi: " . $conn->connect_error]));
}

header('Content-Type: application/json');

// Iegūst darbību
$action = $_GET['action'] ?? '';

switch ($action) {
    // Pievienot jaunu ierakstu
    case 'create':
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['question'], $data['answer'])) {
            echo json_encode(["error" => "Nepareizi ievaddati."]);
            exit;
        }

        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        $stmt = $conn->prepare("INSERT INTO rb_kvalif_faq_410 (question, answer) VALUES (?, ?)");
        $stmt->bind_param("ss", $question, $answer);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Lasīt visus ierakstus
    case 'read':
        $result = $conn->query("SELECT * FROM rb_kvalif_faq_410");

        if (!$result) {
            echo json_encode(["error" => $conn->error]);
            exit;
        }

        $faqs = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode($faqs);
        break;

    // Atjaunināt esošu ierakstu
    case 'update':
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['id'], $data['question'], $data['answer'])) {
            echo json_encode(["error" => "Nepareizi ievaddati."]);
            exit;
        }

        $id = intval($data['id']);
        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        $stmt = $conn->prepare("UPDATE rb_kvalif_faq_410 SET question = ?, answer = ? WHERE id = ?");
        $stmt->bind_param("ssi", $question, $answer, $id);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Dzēst ierakstu
    case 'delete':
        $id = intval($_GET['id']);
        if (!$id) {
            echo json_encode(["error" => "Nepareizs ID."]);
            exit;
        }

        $stmt = $conn->prepare("DELETE FROM rb_kvalif_faq_410 WHERE id = ?");
        $stmt->bind_param("i", $id);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    // Noklusējuma gadījums, ja darbība nav norādīta vai ir nederīga
    default:
        echo json_encode(["error" => "Nepareiza darbība."]);
}

$conn->close();
?>